import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

/** An instance of this class is a frame with four sets of buttons.
    The upper left set is has no border. The sets of buttons in the
    upper right, lower left, and upper right all have borders, which
    were produced by calls on static methods in class BorderFactory.
    
    Each of the four sets of buttons is a JPanel.
    The top row of two JPanels is a JPanel pTop.
    The bottom row of two JPanels is a JPanel pBot.
    pTop and pBot are placed in a Box, with a vertical strut
      between them to separate them a bit.
    Finally, that Box is placed in the CENTER of the JFrame.
   */
public class BorderDemo extends JFrame {

    public BorderDemo() {
        super("border demo");
        
        JPanel bTopLeft= new JPanel();
		bTopLeft.add(new JRadioButton("one"));
		bTopLeft.add(new JRadioButton("two"));
		bTopLeft.add(new JRadioButton("three"));
		
        JPanel bTopRight= new JPanel();
		bTopRight.add(new JRadioButton("one"));
		bTopRight.add(new JRadioButton("two"));
		bTopRight.add(new JRadioButton("three"));
		
		JPanel pTop= new JPanel();
		pTop.add(bTopLeft);
		pTop.add(bTopRight);

		JPanel bBotLeft= new JPanel();
		bBotLeft.add(new JRadioButton("one"));
		bBotLeft.add(new JRadioButton("two"));
		bBotLeft.add(new JRadioButton("three"));

		JPanel bBotRight= new JPanel();
		bBotRight.add(new JRadioButton("one"));
		bBotRight.add(new JRadioButton("two"));
		bBotRight.add(new JRadioButton("three"));
		
		JPanel pBot= new JPanel();
		pBot.add(bBotLeft);
		pBot.add(bBotRight);

		bTopRight.setBorder(BorderFactory.createBevelBorder(
		         BevelBorder.LOWERED));
		bBotLeft.setBorder(BorderFactory.createBevelBorder(
		         BevelBorder.LOWERED, Color.pink, Color.red));
		bBotRight.setBorder(BorderFactory.createMatteBorder(
		         3, 5, 6, 5, Color.green));
				
		Box b= new Box(BoxLayout.Y_AXIS);
		b.add(pTop);
		b.add(Box.createVerticalStrut(10));
		b.add(pBot);
		
		Container cp= getContentPane();
		cp.add(b, BorderLayout.CENTER);
		cp.add(new JLabel(" "), BorderLayout.SOUTH);
		cp.add(new JLabel("    "), BorderLayout.EAST);
		cp.add(new JLabel("    "), BorderLayout.WEST);
		setResizable(false);
		pack();
    }

	public static void main(String args[]) {
		BorderDemo bd= new BorderDemo();
		bd.setVisible(true);
		
		

	}
}
